# **Hacktoria CTF: Substation Bombing Write-up**

## **Challenge Overview**

**Challenge Date:** March 16, 2025

**Objective:** Find information about a targeted substation in order to unlock a ZIP file containing the flag.

**Required Information:**

1. Names of the suburb and province where the substation is located  
2. Name of the substation  
3. Voltage class of the substation (in kV)

**ZIP Password Format:** `SuburbName-ProvinceName-SubstationName-XX/XX`

* Note: For multi-word names, spaces must be omitted

## **The Investigation Process**

### **Step 1: Locating the Substation Area**

Our first task is to identify the suburb and province where the targeted substation is located. The challenge provides a hint about using the "Eyes on Russia Map".

1. Visit the [Eyes on Russia Map](https://www.eyesonrussia.org/)  
2. Search for event ID "UW53036" or filter using these parameters:  
   * Keyword: "substation"  
   * Category: "Bombing or Explosion"  
   * Sector affected: "Infrastructure"  
3. The search results reveal the substation is located in:  
   * **Suburb:** Антонівка (Antonivka)  
   * **Province:** Херсонська область (Kherson Oblast), Ukraine

### **Step 2: Identifying the Specific Substation**

Now that we know the general location, we need to find the specific substation.

1. Using Google Maps, search for substations in the Antonivka area of Kherson Oblast  
2. Look for electrical infrastructure markers in the area: [Google Maps Link](https://maps.app.goo.gl/WM7qZa5sroa43Ydy7)  
3. Identify the substation name: **Кіндійська**

### **Step 3: Determining the Voltage Class**

For the final piece of information, we need to identify the voltage class of the substation.

1. Look for technical information on the substation, which can be found through:  
   * Local energy company website: [Херсонобленерго](https://ksoe.com.ua/)  
   * Supporting documents:  
     * [Municipal document](https://miskrada-ks.gov.ua/wp-content/uploads/2021/07/s424-2021.pdf)  
     * [Technical specifications](https://www.ztoe.com.ua/xvii.php)  
2. The voltage class is identified as: **35/6 kV**

### **Step 4: Unlocking the ZIP File**

Once all information is gathered, format the password according to the specified pattern:

Password: `Антонівка-Херсонськаобласть-Кіндійська-35/6`

Note that "Херсонська область" becomes "Херсонськаобласть" since spaces must be omitted.

## **Tools Used**

* [Eyes on Russia Map](https://www.eyesonrussia.org/) \- For identifying the attack location  
* Google Maps \- For pinpointing the exact substation  
* Ukrainian energy company websites \- For technical specifications

## **Conclusion**

This challenge required a combination of OSINT techniques:

* Using specialized mapping resources for conflict zones  
* Navigating foreign language websites and technical documents  
* Understanding electrical infrastructure naming conventions  
* Careful attention to detail in password formatting

Once the ZIP file is unlocked with the correct password, the flag can be retrieved and the challenge is complete.

GitHub documentation by the creator:

https://github.com/substationworm/CTF-Write-Ups/blob/main/HACKTORIA/Discord-24-7-osint/20250316/20250316.md
